/*
 * Decompiled with CFR 0.152.
 */
package info.msxlaunchers.openmsx.launcher.persistence.game;

import info.msxlaunchers.openmsx.launcher.data.backup.DatabaseBackup;
import info.msxlaunchers.openmsx.launcher.log.LauncherLogger;
import info.msxlaunchers.openmsx.launcher.persistence.DatabaseResponse;
import info.msxlaunchers.openmsx.launcher.persistence.NonTransactionalDatabaseOperation;
import info.msxlaunchers.openmsx.launcher.persistence.game.GetDatabaseBackupsResponse;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

final class GetDatabaseBackupsAction
extends NonTransactionalDatabaseOperation<Set<DatabaseBackup>> {
    private static final String GET_DATABASE_BACKUPS_STATEMENT = "SELECT * FROM database_backup WHERE IDDB=?";
    private final String database;

    GetDatabaseBackupsAction(String database) {
        this.database = database;
    }

    @Override
    public DatabaseResponse<Set<DatabaseBackup>> executeNonTransactionalOperation(Connection connection) {
        HashSet<DatabaseBackup> backups = new HashSet<DatabaseBackup>();
        long databaseId = this.getDatabaseId(connection, this.database);
        try (PreparedStatement statement = connection.prepareStatement(GET_DATABASE_BACKUPS_STATEMENT);){
            statement.setLong(1, databaseId);
            try (ResultSet result = statement.executeQuery();){
                while (result.next()) {
                    backups.add(this.getDatabaseBackupFromResultSet(result));
                }
            }
        }
        catch (SQLException se) {
            LauncherLogger.logException(this, se);
        }
        return new GetDatabaseBackupsResponse(backups);
    }

    private DatabaseBackup getDatabaseBackupFromResultSet(ResultSet result) throws SQLException {
        return new DatabaseBackup(this.database, result.getTimestamp("time"));
    }
}

